/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.gateway.config;

import com.jeeplus.gateway.excepiton.JwtAccessDeniedHandler;
import com.jeeplus.gateway.excepiton.JwtAuthenticationEntryPoint;
import com.jeeplus.gateway.filter.JWTFilter;
import com.jeeplus.gateway.security.TokenProvider;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.security.SecurityProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.authentication.UserDetailsRepositoryReactiveAuthenticationManager;
import org.springframework.security.config.annotation.method.configuration.EnableReactiveMethodSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.reactive.EnableWebFluxSecurity;
import org.springframework.security.config.web.server.SecurityWebFiltersOrder;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.core.userdetails.MapReactiveUserDetailsService;
import org.springframework.security.core.userdetails.ReactiveUserDetailsService;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.web.server.SecurityWebFilterChain;
import org.springframework.security.web.server.ServerAuthenticationEntryPoint;
import org.springframework.security.web.server.authorization.ServerAccessDeniedHandler;
import org.springframework.security.web.server.header.ReferrerPolicyServerHttpHeadersWriter;
import org.springframework.security.web.server.savedrequest.NoOpServerRequestCache;
import org.springframework.security.web.server.savedrequest.ServerRequestCache;
import org.springframework.security.web.server.util.matcher.NegatedServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.OrServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatchers;
import org.springframework.util.StringUtils;
import org.springframework.web.server.WebFilter;

@EnableWebFluxSecurity
@EnableWebSecurity
@EnableReactiveMethodSecurity
public class SecurityConfiguration {
    @Value(value="${ignore.whiteList}")
    private String whiteList;
    private final TokenProvider tokenProvider;
    private final JwtAccessDeniedHandler jwtAccessDeniedHandler;
    private final JwtAuthenticationEntryPoint jwtAuthenticationEntryPoint;

    public SecurityConfiguration(TokenProvider tokenProvider, JwtAuthenticationEntryPoint jwtAuthenticationEntryPoint, JwtAccessDeniedHandler jwtAccessDeniedHandler) {
        this.tokenProvider = tokenProvider;
        this.jwtAccessDeniedHandler = jwtAccessDeniedHandler;
        this.jwtAuthenticationEntryPoint = jwtAuthenticationEntryPoint;
    }

    @Bean
    public MapReactiveUserDetailsService userDetailsService(SecurityProperties properties) {
        SecurityProperties.User user = properties.getUser();
        UserDetails userDetails = User.withUsername((String)user.getName()).password("{noop}" + user.getPassword()).roles(StringUtils.toStringArray((Collection)user.getRoles())).build();
        return new MapReactiveUserDetailsService(new UserDetails[]{userDetails});
    }

    @Bean
    public ReactiveAuthenticationManager reactiveAuthenticationManager(ReactiveUserDetailsService userDetailsService) {
        return new UserDetailsRepositoryReactiveAuthenticationManager(userDetailsService);
    }

    @Bean
    public SecurityWebFilterChain springSecurityFilterChain(ServerHttpSecurity http) {
        ((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)http.securityMatcher((ServerWebExchangeMatcher)new NegatedServerWebExchangeMatcher((ServerWebExchangeMatcher)new OrServerWebExchangeMatcher(new ServerWebExchangeMatcher[]{ServerWebExchangeMatchers.pathMatchers((String[])this.whiteList.split(",")), ServerWebExchangeMatchers.pathMatchers((HttpMethod)HttpMethod.OPTIONS, (String[])new String[]{"/**"})}))).csrf().disable().addFilterAt((WebFilter)new JWTFilter(this.tokenProvider), SecurityWebFiltersOrder.HTTP_BASIC).exceptionHandling().accessDeniedHandler((ServerAccessDeniedHandler)this.jwtAccessDeniedHandler).authenticationEntryPoint((ServerAuthenticationEntryPoint)this.jwtAuthenticationEntryPoint).and().headers().referrerPolicy(ReferrerPolicyServerHttpHeadersWriter.ReferrerPolicy.STRICT_ORIGIN_WHEN_CROSS_ORIGIN).and().featurePolicy("geolocation 'none'; midi 'none'; sync-xhr 'none'; microphone 'none'; camera 'none'; magnetometer 'none'; gyroscope 'none'; fullscreen 'self'; payment 'none'").and().frameOptions().disable().and().requestCache().requestCache((ServerRequestCache)NoOpServerRequestCache.getInstance()).and().authorizeExchange().pathMatchers(this.whiteList.split(","))).permitAll().pathMatchers(new String[]{"/api/**"})).authenticated().pathMatchers(new String[]{"/management/health"})).permitAll().pathMatchers(new String[]{"/management/health/**"})).permitAll().pathMatchers(new String[]{"/management/info"})).permitAll().pathMatchers(new String[]{"/management/prometheus"})).permitAll().pathMatchers(HttpMethod.OPTIONS, new String[]{"/**"})).permitAll().anyExchange().authenticated();
        return http.build();
    }
}

