/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.ureport;

import com.jeeplus.common.utils.ResponseUtil;
import com.jeeplus.ureport.ReportService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/reports"})
public class ReportController {
    private static final Logger log = LoggerFactory.getLogger(ReportController.class);
    private final ReportService reportService;

    ReportController(ReportService reportService) {
        this.reportService = reportService;
    }

    @GetMapping(value={"/list"})
    public ResponseEntity getReports() {
        log.debug("ReportController.getReports");
        return ResponseUtil.newInstance().add("reports", this.reportService.getReportFiles()).add("prefix", (Object)"file:").ok();
    }

    @DeleteMapping(value={"/delete"})
    public ResponseEntity delete(@RequestParam(value="id") String id) {
        log.debug("ReportController.deleteById {}", (Object)id);
        this.reportService.deleteReport(id);
        return ResponseEntity.ok((Object)"\u5220\u9664\u62a5\u8868\u6210\u529f!");
    }
}

